

<?php $__env->startSection('title', 'User Details'); ?>
<?php $__env->startSection('page-title', 'User Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center space-x-6 mb-6">
            <div class="h-20 w-20 rounded-full bg-blue-500 flex items-center justify-center text-white text-2xl font-bold">
                <?php echo e($user->initials); ?>

            </div>
            <div>
                <h2 class="text-2xl font-bold text-gray-900"><?php echo e($user->name); ?></h2>
                <p class="text-gray-600"><?php echo e($user->email); ?></p>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h4 class="text-sm font-medium text-gray-500">Phone</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($user->display_phone); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Status</h4>
                <span class="mt-1 px-3 py-1 text-sm font-semibold rounded-full 
                    <?php echo e($user->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                    <?php echo e(ucfirst($user->status)); ?>

                </span>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Member Since</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($user->formatted_created_at); ?></p>
            </div>

            <div>
                <h4 class="text-sm font-medium text-gray-500">Last Updated</h4>
                <p class="mt-1 text-lg font-semibold text-gray-900"><?php echo e($user->formatted_updated_at); ?></p>
            </div>
        </div>

        <div class="mt-6 flex justify-end space-x-3">
            <a href="<?php echo e(route('users.index')); ?>" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">
                Back to List
            </a>
            <a href="<?php echo e(route('users.edit', $user)); ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">
                Edit User
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/users/show.blade.php ENDPATH**/ ?>