

<?php $__env->startSection('title', 'Dashboard- Canindigo INC'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto">
    <!-- Welcome Header -->
    <!-- <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-900">Welcome back, <?php echo e(Auth::user()->name); ?>! 👋</h1>
        <p class="text-gray-600">Here's what's happening today.</p>
    </div> -->

    <!-- Statistics Cards Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Total Hours Worked -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-clock text-blue-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Total Hours Worked</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($hoursData['total_all'] ?? 0); ?> hrs</p>
                    <p class="text-xs text-gray-500"><?php echo e($hoursData['timesheet_count'] ?? 0); ?> timesheets</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-gray-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-clock text-blue-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Today's Hours</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($dailyHoursData['daily_all'] ?? 0); ?> hrs</p>
                    <p class="text-xs text-gray-500"><?php echo e($dailyHoursData['daily_timesheet_count'] ?? 0); ?> entries today</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-pink-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-car text-green-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Today's Distance</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($totalKmToday ?? 0); ?> KM</p>
                    <p class="text-xs text-gray-500">Driven today</p>
                </div>
            </div>
        </div>
        <!-- Today's Distance -->
        <!-- <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-car text-green-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Total KM</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($totalKmToday ?? 0); ?> KM</p>
                    <p class="text-xs text-gray-500">Vehicle usage</p>
                </div>
            </div>
        </div> -->

        <!-- Pending Expenses -->
       <!--  <div class="bg-white rounded-lg shadow p-6 border-l-4 border-orange-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-receipt text-orange-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Pending Expenses</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pendingExpensesCount ?? 0); ?></p>
                    <p class="text-xs text-gray-500">Awaiting approval</p>
                </div>
            </div>
        </div> -->

        <!-- Vehicle Bookings -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-car-side text-purple-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Vehicle Usage</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($vehicleBookingsCount ?? 0); ?></p>
                    <p class="text-xs text-gray-500">Vehicle bookings</p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-red-500">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-receipt text-purple-600 text-xl"></i>
                    </div>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-medium text-gray-500">Pending Expenses</h3>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($pendingExpensesCount ?? 0); ?></p>
                    <p class="text-xs text-gray-500">Awaiting approval</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Hours Breakdown -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <!-- Regular Hours -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Regular Hours</h3>
                    <p class="text-2xl font-bold text-blue-600"><?php echo e($hoursData['total_regular'] ?? 0); ?> hrs</p>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-business-time text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Weekday Overtime -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Over Time Weekday</h3>
                    <p class="text-2xl font-bold text-orange-600"><?php echo e($hoursData['total_overtime_weekdays'] ?? 0); ?> hrs</p>
                </div>
                <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-plus-circle text-orange-600 text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Weekend Overtime -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Over Time Weekend</h3>
                    <p class="text-2xl font-bold text-red-600"><?php echo e($hoursData['total_overtime_weekend'] ?? 0); ?> hrs</p>
                </div>
                <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-plus-circle text-red-600 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <!-- <div class="bg-white rounded-lg shadow mb-8">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Quick Actions</h3>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <a href="<?php echo e(route('time-sheets.create')); ?>" class="group flex items-center p-4 border border-gray-200 rounded-lg hover:bg-blue-50 hover:border-blue-300 transition duration-200">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center group-hover:bg-blue-200 transition duration-200">
                        <i class="fas fa-plus text-blue-600 text-lg"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-medium text-gray-900 group-hover:text-blue-700">New Timesheet</h4>
                        <p class="text-sm text-gray-500">Add work hours</p>
                    </div>
                    <div class="ml-auto">
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-blue-600"></i>
                    </div>
                </a>
                <a href="<?php echo e(route('vehicle-usage.create')); ?>" class="group flex items-center p-4 border border-gray-200 rounded-lg hover:bg-green-50 hover:border-green-300 transition duration-200">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center group-hover:bg-green-200 transition duration-200">
                        <i class="fas fa-car text-green-600 text-lg"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-medium text-gray-900 group-hover:text-green-700">Book Vehicle</h4>
                        <p class="text-sm text-gray-500">Request vehicle usage</p>
                    </div>
                    <div class="ml-auto">
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-green-600"></i>
                    </div>
                </a>
                <a href="<?php echo e(route('expenses.create')); ?>" class="group flex items-center p-4 border border-gray-200 rounded-lg hover:bg-orange-50 hover:border-orange-300 transition duration-200">
                    <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center group-hover:bg-orange-200 transition duration-200">
                        <i class="fas fa-receipt text-orange-600 text-lg"></i>
                    </div>
                    <div class="ml-4">
                        <h4 class="font-medium text-gray-900 group-hover:text-orange-700">Claim Expense</h4>
                        <p class="text-sm text-gray-500">Submit expense claim</p>
                    </div>
                    <div class="ml-auto">
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-orange-600"></i>
                    </div>
                </a>
            </div>
        </div>
    </div> -->

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Recent Time Sheets -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <h3 class="text-lg font-medium text-gray-900">Recent Time Sheets</h3>
                    <?php if(isset($recentTimeSheets) && $recentTimeSheets->count() > 0): ?>
                    <a href="<?php echo e(route('time-sheets.index')); ?>" class="text-sm text-blue-600 hover:text-blue-800 font-medium">
                        View All
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="p-6">
                <?php if(isset($recentTimeSheets) && $recentTimeSheets->count() > 0): ?>
                    <div class="space-y-4">
                        <?php $__currentLoopData = $recentTimeSheets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timesheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                        <i class="fas fa-clock text-blue-600 text-sm"></i>
                                    </div>
                                    <div class="min-w-0 flex-1">
                                        <h4 class="font-medium text-gray-900 truncate">
                                            <?php echo e($timesheet->project_code ?? 'No Project'); ?>

                                        </h4>
                                        <p class="text-sm text-gray-500">
                                            <?php echo e($timesheet->date ? $timesheet->date->format('M d, Y') : 'No date'); ?>

                                        </p>
                                        <p class="text-xs text-gray-400">
                                            <?php echo e(date('g:i A', strtotime($timesheet->start_time))); ?> - <?php echo e(date('g:i A', strtotime($timesheet->end_time))); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="flex items-center space-x-3 ml-4">
                                <?php
                                    $start = \Carbon\Carbon::parse($timesheet->start_time);
                                    $end = \Carbon\Carbon::parse($timesheet->end_time);
                                    $hours =- round($end->diffInMinutes($start) / 60, 2);
                                ?>
                                <span class="px-3 py-1 text-sm font-semibold bg-blue-100 text-blue-800 rounded-full whitespace-nowrap">
                                    <?php echo e($hours); ?> hrs
                                </span>
                                <a href="<?php echo e(route('time-sheets.show', $timesheet)); ?>" 
                                   class="text-blue-600 hover:text-blue-800 p-2 rounded-lg hover:bg-blue-50 transition duration-200"
                                   title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8">
                        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-clock text-gray-400 text-xl"></i>
                        </div>
                        <p class="text-gray-500 font-medium">No time sheets yet</p>
                        <p class="text-gray-400 text-sm mt-1">Start by creating your first timesheet</p>
                        <a href="<?php echo e(route('time-sheets.create')); ?>" 
                           class="inline-block mt-4 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200 text-sm">
                            Create Timesheet
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Placeholder for Future Activities -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Recent Activities</h3>
            </div>
            <div class="p-6">
                <div class="text-center py-8">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-bell text-gray-400 text-xl"></i>
                    </div>
                    <p class="text-gray-500 font-medium">Activity tracking coming soon</p>
                    <p class="text-gray-400 text-sm mt-1">Your activities will appear here once enabled</p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\Scratch\resources\views/dashboard/index.blade.php ENDPATH**/ ?>