/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 100419
 Source Host           : localhost:3306
 Source Schema         : scratch

 Target Server Type    : MySQL
 Target Server Version : 100419
 File Encoding         : 65001

 Date: 09/10/2025 16:36:45
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for activities
-- ----------------------------
DROP TABLE IF EXISTS `activities`;
CREATE TABLE `activities`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` bigint(20) UNSIGNED NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `properties` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `activities_subject_type_subject_id_index`(`subject_type`, `subject_id`) USING BTREE,
  INDEX `activities_user_id_created_at_index`(`user_id`, `created_at`) USING BTREE,
  CONSTRAINT `activities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cache
-- ----------------------------
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache`  (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cache_locks
-- ----------------------------
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks`  (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for client_sites
-- ----------------------------
DROP TABLE IF EXISTS `client_sites`;
CREATE TABLE `client_sites`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `contact_person` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `contact_phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of client_sites
-- ----------------------------
INSERT INTO `client_sites` VALUES (1, 'Shell Oman HQ', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (2, 'PDO Tower', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (3, 'Oman Oil Refinery', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (4, 'Ministry of Transport', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (5, 'Bank Muscat HQ', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (6, 'Sultanate Court', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');
INSERT INTO `client_sites` VALUES (7, 'Royal Hospital', NULL, NULL, NULL, 1, '2025-10-02 07:56:48', '2025-10-02 07:56:48');

-- ----------------------------
-- Table structure for expense_categories
-- ----------------------------
DROP TABLE IF EXISTS `expense_categories`;
CREATE TABLE `expense_categories`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of expense_categories
-- ----------------------------
INSERT INTO `expense_categories` VALUES (1, 'Travel', NULL, 1, '2025-10-02 07:56:38', '2025-10-02 07:56:38');
INSERT INTO `expense_categories` VALUES (2, 'Fuel', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (3, 'Equipment', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (4, 'Software', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (5, 'Training', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (6, 'Meals', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (7, 'Accommodation', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (8, 'Communication', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');
INSERT INTO `expense_categories` VALUES (9, 'Other', NULL, 1, '2025-10-02 07:56:39', '2025-10-02 07:56:39');

-- ----------------------------
-- Table structure for expenses
-- ----------------------------
DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(10, 2) NOT NULL,
  `expense_date` date NOT NULL,
  `business_purpose` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_site_id` bigint(20) UNSIGNED NOT NULL,
  `receipt_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `admin_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `expenses_user_id_foreign`(`user_id`) USING BTREE,
  INDEX `expenses_category_id_foreign`(`category_id`) USING BTREE,
  INDEX `expenses_client_site_id_foreign`(`client_site_id`) USING BTREE,
  CONSTRAINT `expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expense_categories` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `expenses_client_site_id_foreign` FOREIGN KEY (`client_site_id`) REFERENCES `client_sites` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `expenses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of expenses
-- ----------------------------
INSERT INTO `expenses` VALUES (1, 1, 'due', 1, 250.00, '2025-10-02', 'dsafdsa', 1, 'receipts/lXJg3FMpZkEPXEpwvfTtLWxvEH0YcpTGTCgegKTF.png', 'approved', NULL, '2025-10-02 08:35:48', '2025-10-02 08:35:48');
INSERT INTO `expenses` VALUES (2, 2, 'Visit Client Site', 6, 10.00, '2025-10-03', 'dafdf', 3, 'receipts/mHkSauu2lDlw8zZMyN5BgkSrhASwEj7rddyi2wkW.png', 'approved', NULL, '2025-10-03 09:11:52', '2025-10-03 09:11:52');
INSERT INTO `expenses` VALUES (3, 2, 'Visit Client Site', 2, 158.00, '2025-10-06', 'business trip', 4, 'receipts/7NXdRVWTzsSdhOpxxAHqK9m0h7NzexRNOrlcJF1h.png', 'pending', NULL, '2025-10-06 10:18:17', '2025-10-06 10:18:17');
INSERT INTO `expenses` VALUES (4, 2, 'Visit Client Site', 5, 123.00, '2025-10-06', 'abc', 5, 'receipts/IVkzeugf7HswMJhaBfdGDdwe4EyPgK3UAPc2ZomN.png', 'rejected', NULL, '2025-10-06 10:22:18', '2025-10-06 10:22:18');

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp(0) NOT NULL DEFAULT current_timestamp(0),
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `failed_jobs_uuid_unique`(`uuid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for job_batches
-- ----------------------------
DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches`  (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `cancelled_at` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for jobs
-- ----------------------------
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) UNSIGNED NOT NULL,
  `reserved_at` int(10) UNSIGNED NULL DEFAULT NULL,
  `available_at` int(10) UNSIGNED NOT NULL,
  `created_at` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `jobs_queue_index`(`queue`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of migrations
-- ----------------------------
INSERT INTO `migrations` VALUES (1, '0001_01_01_000000_create_users_table', 1);
INSERT INTO `migrations` VALUES (2, '0001_01_01_000001_create_cache_table', 1);
INSERT INTO `migrations` VALUES (3, '0001_01_01_000002_create_jobs_table', 1);
INSERT INTO `migrations` VALUES (4, '2025_09_30_094224_create_vehicles_table', 1);
INSERT INTO `migrations` VALUES (5, '2025_09_30_094248_create_vehicle_usages_table', 1);
INSERT INTO `migrations` VALUES (6, '2025_09_30_105349_add_status_to_users_table', 1);
INSERT INTO `migrations` VALUES (7, '2025_09_30_105748_create_users_table_with_status', 2);
INSERT INTO `migrations` VALUES (8, '2025_09_30_174805_create_time_sheets_table', 3);
INSERT INTO `migrations` VALUES (9, '2025_10_01_052231_add_role_to_users_table', 3);
INSERT INTO `migrations` VALUES (10, '2025_10_02_072532_create_expense_categories_table', 3);
INSERT INTO `migrations` VALUES (11, '2025_10_02_072547_create_client_sites_table', 3);
INSERT INTO `migrations` VALUES (12, '2025_10_02_072552_create_expenses_table', 3);
INSERT INTO `migrations` VALUES (13, '2025_10_03_061419_create_project_codes_table', 4);
INSERT INTO `migrations` VALUES (14, '2025_10_06_080454_create_activities_table', 5);

-- ----------------------------
-- Table structure for password_reset_tokens
-- ----------------------------
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens`  (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`email`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for project_codes
-- ----------------------------
DROP TABLE IF EXISTS `project_codes`;
CREATE TABLE `project_codes`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `project_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `price` decimal(12, 2) NULL DEFAULT NULL,
  `updated_at` datetime(0) NULL DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of project_codes
-- ----------------------------
INSERT INTO `project_codes` VALUES (1, 'CLIENT MAINT', 'Client Site Maintenance', 25.00, '2025-10-03 06:26:38', '2025-10-03 06:26:38');
INSERT INTO `project_codes` VALUES (2, 'CLIENT INSTALL', 'Client Installation Project ', 30.00, '2025-10-03 06:26:38', '2025-10-03 06:26:38');
INSERT INTO `project_codes` VALUES (3, 'IT-SUPPORT', 'General IT Support', 20.00, '2025-10-03 06:26:38', '2025-10-03 06:26:38');
INSERT INTO `project_codes` VALUES (4, 'EMERGENCY', 'Emergency Call-Out', 35.00, '2025-10-03 06:26:38', '2025-10-03 06:26:38');

-- ----------------------------
-- Table structure for sessions
-- ----------------------------
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions`  (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) UNSIGNED NULL DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sessions_user_id_index`(`user_id`) USING BTREE,
  INDEX `sessions_last_activity_index`(`last_activity`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sessions
-- ----------------------------
INSERT INTO `sessions` VALUES ('DvQy4R56NSvjCxMHo8JUEdXMckjyHcXAIGr7IxeU', 2, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'YTo0OntzOjY6Il90b2tlbiI7czo0MDoiNG5ESElIbDNYRjlkazRPbWZDbDBTS1J6dndOa2Q0SWk5SWhmbm1sSSI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzE6Imh0dHA6Ly9sb2NhbGhvc3Q6ODAwMC9kYXNoYm9hcmQiO31zOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToyO30=', 1760009217);

-- ----------------------------
-- Table structure for time_sheets
-- ----------------------------
DROP TABLE IF EXISTS `time_sheets`;
CREATE TABLE `time_sheets`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `start_time` time(0) NOT NULL,
  `end_time` time(0) NOT NULL,
  `project_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime_weekdays` decimal(5, 2) NOT NULL DEFAULT 0,
  `overtime_weekend` decimal(5, 2) NOT NULL DEFAULT 0,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `time_sheets_user_id_foreign`(`user_id`) USING BTREE,
  CONSTRAINT `time_sheets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of time_sheets
-- ----------------------------
INSERT INTO `time_sheets` VALUES (3, '2025-10-05', '13:54:00', '15:57:00', 'visit', 2.50, 0.00, NULL, 2, '2025-10-06 05:52:49', '2025-10-06 05:52:49');
INSERT INTO `time_sheets` VALUES (4, '2025-10-06', '15:27:00', '23:27:00', 'VS001', 0.00, 5.00, NULL, 2, '2025-10-06 06:24:00', '2025-10-06 06:24:00');
INSERT INTO `time_sheets` VALUES (8, '2025-10-07', '11:03:00', '16:08:00', 'visiting to client maintanance', 0.00, 0.00, NULL, 2, '2025-10-07 05:02:16', '2025-10-07 05:02:16');
INSERT INTO `time_sheets` VALUES (9, '2025-10-07', '00:30:00', '23:30:00', 'visit site', 0.00, 0.00, NULL, 2, '2025-10-07 12:24:32', '2025-10-07 12:24:32');
INSERT INTO `time_sheets` VALUES (13, '2025-10-09', '01:52:00', '03:54:00', 'VS001', 0.00, 0.00, NULL, 2, '2025-10-09 05:49:32', '2025-10-09 05:49:32');

-- ----------------------------
-- Table structure for user-old
-- ----------------------------
DROP TABLE IF EXISTS `user-old`;
CREATE TABLE `user-old`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `email_verified_at` timestamp(0) NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `users_email_unique`(`email`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user-old
-- ----------------------------
INSERT INTO `user-old` VALUES (1, 'Admin User', 'admin@example.com', 'active', NULL, '$2y$12$/TWsdL.BHBMTN/O7k15JKOtXEFQ5cFELgl3NoMCf0tYqV1OaMtkEa', NULL, NULL, NULL);
INSERT INTO `user-old` VALUES (2, 'Regular User', 'user@example.com', 'active', NULL, '$2y$12$4xvrRa6.gtYL5Gr4Hn68veHEnjO6Ls5bTWIQ2aR/NSTsWwRlcPwsC', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `email_verified_at` timestamp(0) NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  `role` enum('user','admin','manager','editor') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `users_email_unique`(`email`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES (1, 'Admin User', 'admin@example.com', NULL, 'active', NULL, '$2y$12$/TWsdL.BHBMTN/O7k15JKOtXEFQ5cFELgl3NoMCf0tYqV1OaMtkEa', NULL, '2025-10-02 07:57:38', '2025-10-02 07:57:38', 'admin');
INSERT INTO `users` VALUES (2, 'Regular User', 'user@example.com', NULL, 'active', NULL, '$2y$12$4xvrRa6.gtYL5Gr4Hn68veHEnjO6Ls5bTWIQ2aR/NSTsWwRlcPwsC', NULL, '2025-10-02 07:57:38', '2025-10-02 07:57:38', 'user');
INSERT INTO `users` VALUES (4, 'Driver', 'driver@canindigo.com', NULL, 'active', NULL, '$2y$12$66K0r73i8mkcEH3h5Cm4F.8SfH4QeDIyAu62UoG.ZLlZ0X7jpNpzG', NULL, '2025-10-07 04:48:23', '2025-10-07 04:48:23', 'user');

-- ----------------------------
-- Table structure for vehicle_usages
-- ----------------------------
DROP TABLE IF EXISTS `vehicle_usages`;
CREATE TABLE `vehicle_usages`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `vehicle_id` bigint(20) UNSIGNED NOT NULL,
  `date` date NOT NULL,
  `start_km` decimal(10, 2) NOT NULL,
  `end_km` decimal(10, 2) NOT NULL,
  `fuel_consumption` decimal(8, 2) NOT NULL,
  `trip_purpose` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `receipt_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `vehicle_usages_vehicle_id_foreign`(`vehicle_id`) USING BTREE,
  INDEX `vehicle_usages_user_id_foreign`(`user_id`) USING BTREE,
  CONSTRAINT `vehicle_usages_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user-old` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT,
  CONSTRAINT `vehicle_usages_vehicle_id_foreign` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of vehicle_usages
-- ----------------------------
INSERT INTO `vehicle_usages` VALUES (8, 2, '2025-10-06', 4500.00, 5000.00, 25.00, 'vtre', NULL, 2, '2025-10-06 08:15:44', '2025-10-06 08:15:44');
INSERT INTO `vehicle_usages` VALUES (9, 4, '2025-10-06', 700.00, 1000.00, 25.00, 'yes', NULL, 2, '2025-10-06 08:22:42', '2025-10-06 08:22:42');
INSERT INTO `vehicle_usages` VALUES (10, 3, '2025-10-07', 2670.00, 2700.00, 1.50, 'Vehicle Maintanance', NULL, 2, '2025-10-07 06:53:53', '2025-10-07 06:53:53');

-- ----------------------------
-- Table structure for vehicles
-- ----------------------------
DROP TABLE IF EXISTS `vehicles`;
CREATE TABLE `vehicles`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `registration_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `vehicle_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `current_km` decimal(10, 2) NOT NULL DEFAULT 0,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `vehicles_registration_number_unique`(`registration_number`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of vehicles
-- ----------------------------
INSERT INTO `vehicles` VALUES (1, 'Toyota Hilux', 'Pickup Truck', 'VH001', 'White', 1850.00, 'active', '2025-10-02 07:58:14', '2025-10-08 07:25:24');
INSERT INTO `vehicles` VALUES (2, 'Ford Transit', 'van', 'VH002', 'Blue', 5000.00, 'active', '2025-10-02 07:58:14', '2025-10-06 08:15:44');
INSERT INTO `vehicles` VALUES (3, 'Nissan Patrol ', 'SUV', 'VH003', 'Red', 2700.00, 'active', '2025-10-02 07:58:14', '2025-10-07 06:53:53');
INSERT INTO `vehicles` VALUES (4, 'Toyota Camry ', 'Sedan', 'VH004', 'Green', 1000.00, 'active', '2025-10-02 07:58:14', '2025-10-06 08:22:42');

SET FOREIGN_KEY_CHECKS = 1;
