<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\TimeSheetController;
use App\Http\Controllers\VehicleUsageController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ExpenseController;

// Public Routes
Route::get('/', function () {
    return view('welcome');
});

// Authentication Routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Protected Routes (Require Authentication)
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Time Sheets
    Route::resource('time-sheets', TimeSheetController::class);
    
    // Vehicle Usage
    Route::resource('vehicle-usage', VehicleUsageController::class);
    
    // Users (only for admin later)
    Route::resource('users', UserController::class);
    
    // Other pages
    Route::get('/products', function () {
        return view('pages.products');
    })->name('products.index');
    
    Route::get('/orders', function () {
        return view('pages.orders');
    })->name('orders.index');
    
    Route::get('/settings', function () {
        return view('pages.settings');
    })->name('settings');
    
    Route::get('/reports/sales', function () {
        return view('pages.reports.sales');
    })->name('reports.sales');
    
    Route::get('/reports/users', function () {
        return view('pages.reports.users');
    })->name('reports.users');
});

// Admin-only routes for user management
Route::middleware(['auth', 'admin'])->group(function () {
    Route::get('/admin/users', [UserController::class, 'index'])->name('admin.users.index');
    Route::get('/admin/users/{user}/edit', [UserController::class, 'edit'])->name('admin.users.edit');
    Route::put('/admin/users/{user}', [UserController::class, 'update'])->name('admin.users.update');
    Route::delete('/admin/users/{user}', [UserController::class, 'destroy'])->name('admin.users.destroy');
});

// Regular user routes (profile management - users can edit their own profile)
Route::middleware(['auth'])->group(function () {
    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::put('/profile', [UserController::class, 'updateProfile'])->name('profile.update');
});
// routes/web.php
Route::middleware(['auth'])->group(function () {
    // Expense Claims Routes
    Route::prefix('expenses')->name('expenses.')->group(function () {
        Route::get('/', [ExpenseController::class, 'index'])->name('index');
        Route::get('/create', [ExpenseController::class, 'create'])->name('create');
        Route::post('/', [ExpenseController::class, 'store'])->name('store');
        Route::get('/{expense}', [ExpenseController::class, 'show'])->name('show');
        Route::get('/{expense}/download-receipt', [ExpenseController::class, 'downloadReceipt'])->name('download-receipt');
    });
});