<?php
// database/seeders/ProjectCodeSeeder.php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ProjectCode;

class ProjectCodeSeeder extends Seeder
{
    public function run()
    {
        // Option 1: Using Eloquent
        ProjectCode::create([
            'project_name' => 'CLIENT MAINT',
            'description' => 'Client Site Maintenance',
            'price' => 25
        ]);

       ProjectCode::create([
            'project_name' => 'CLIENT INSTALL',
            'description' => 'Client Installation Project ',
            'price' => 30
        ]);

        ProjectCode::create([
            'project_name' => 'IT-SUPPORT',
            'description' => 'General IT Support',
            'price' => 20
        ]);
        ProjectCode::create([
            'project_name' => 'EMERGENCY',
            'description' => 'Emergency Call-Out',
            'price' => 35
        ]);

        // Option 2: Using DB Facade for multiple records
        // DB::table('project_codes')->insert([
        //     [
        //         'project_code' => 'PROJ-001',
        //         'project_name' => 'Website Redesign',
        //         'description' => 'Complete website redesign and development',
        //         'start_date' => '2024-01-01',
        //         'end_date' => '2024-06-30',
        //         'status' => 'active',
        //         'budget' => 50000.00,
        //         'client_name' => 'ABC Corporation',
        //         'project_manager' => 'John Smith',
        //         'created_at' => now(),
        //         'updated_at' => now(),
        //     ],
        //     // ... more records
        // ]);
    }
}